/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.content;

import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.content.IVWContentViewMouseListener;
import filenet.vw.toolkit.admin.content.VWConfigContentViewPane;
import filenet.vw.toolkit.admin.content.VWConfigIcon;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRegionNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerVWServiceNode;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

class VWContentViewMouseAdapter
extends MouseAdapter {
    private VWConfigContentViewPane m_contentView = null;
    private IVWContentViewMouseListener m_contentViewMouseListener = null;
    private VWSessionInfo m_vwSessionInfo = null;

    public VWContentViewMouseAdapter(VWConfigContentViewPane contentPane, IVWContentViewMouseListener contentViewMouseListener, VWSessionInfo sessionInfo) {
        this.m_contentView = contentPane;
        this.m_contentViewMouseListener = contentViewMouseListener;
        this.m_vwSessionInfo = sessionInfo;
    }

    public void mouseClicked(MouseEvent event) {
        Object obj = event.getSource();
        if (obj instanceof VWConfigIcon) {
            VWConfigIcon aIcon = (VWConfigIcon)obj;
            VWConfigBaseNode focus = aIcon.m_node;
            if (event.getClickCount() == 2) {
                int nodeType = focus.getType();
                if (nodeType == 19) {
                    VWConfigRegionNode rNode = (VWConfigRegionNode)focus;
                    if (rNode.getSessionInfo() == null) {
                        this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_LOGON));
                    } else {
                        this.m_contentViewMouseListener.displayContent(focus);
                    }
                } else if (nodeType == 5) {
                    this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_COMPONENT_PROPERTIES));
                } else if (nodeType == 1 || nodeType == 2) {
                    this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_QUEUE_PROPERTIES));
                } else if (nodeType == 3) {
                    this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_ROSTER_PROPERTIES));
                } else if (nodeType == 4) {
                    this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_EVENTLOG_PROPERTIES));
                } else if (nodeType == 6) {
                    this.m_contentView.actionPerformed(new ActionEvent(this, 1001, VWConfigActionCommand.ACMD_APPSPACE_PROPERTIES));
                } else if ((nodeType & 0x10) == 16) {
                    this.m_contentViewMouseListener.displayContent(focus);
                }
            }
        }
    }

    public void mousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        } else {
            Object obj = event.getSource();
            VWConfigIcon aIcon = (VWConfigIcon)obj;
            VWConfigBaseNode focus = aIcon.m_node;
            this.m_contentView.changeFocus(focus);
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (event.isPopupTrigger()) {
            this.showPopup(event);
        }
    }

    protected void releaseResources() {
        this.m_contentView = null;
        this.m_contentViewMouseListener = null;
    }

    private void showPopup(MouseEvent event) {
        Object obj = event.getSource();
        if (obj instanceof VWConfigIcon) {
            VWConfigIcon aIcon = (VWConfigIcon)obj;
            aIcon.doClick();
            aIcon.setSelected(true);
            VWConfigBaseNode focus = aIcon.m_node;
            this.m_contentView.changeFocus(focus);
            String actionCmd = aIcon.getActionCommand();
            VWConfigContextMenu mi = null;
            if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_FOLDER) == 0) {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this.m_contentView, focus);
            } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_CONSOLE_ROOT) == 0) {
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 17, this.m_contentView, focus);
            } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SYSTEM) == 0) {
                VWConfigVWServiceNode svcNode = (VWConfigVWServiceNode)aIcon.m_node;
                if (svcNode != null && svcNode instanceof VWDesignerVWServiceNode) {
                    return;
                }
                mi = new VWConfigContextMenu(this.m_vwSessionInfo, 1, this.m_contentView, focus);
                mi.setSystemMenus((VWConfigVWServiceNode)focus);
            } else if (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_REGION) == 0) {
                VWConfigRegionNode rNode = (VWConfigRegionNode)aIcon.m_node;
                if (rNode.getSessionInfo() == null) {
                    mi = new VWConfigContextMenu(this.m_vwSessionInfo, 5, this.m_contentView, focus);
                } else {
                    mi = rNode instanceof VWDesignerRegionNode ? new VWConfigContextMenu(rNode.getSessionInfo(), 3, this.m_contentView, focus) : new VWConfigContextMenu(rNode.getSessionInfo(), 2, this.m_contentView, focus);
                    mi.setRegionMenus((VWConfigRegionNode)focus);
                }
            } else {
                mi = VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_SERVER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 4, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 6, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 8, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 7, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_WORK_QUEUE) == 0 || VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_USER_QUEUE) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 13, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_COMP_QUEUE) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 12, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 9, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_ROSTER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 14, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 10, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_EVENTLOG) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 15, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE_FOLDER) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 11, this.m_contentView, focus) : (VWStringUtils.compare(actionCmd, VWConfigActionCommand.ACMD_APPSPACE) == 0 ? new VWConfigContextMenu(this.m_vwSessionInfo, 16, this.m_contentView, focus) : new VWConfigContextMenu(this.m_vwSessionInfo, 18, this.m_contentView, focus))))))))))));
            }
            if (mi != null) {
                Point p = event.getPoint();
                mi.show(aIcon, p.x, p.y);
            }
        }
    }
}

